<?php

/**
 * @author Iman Yazdani Charati
 * @copyright 2017
 * @package ICP - Shop min
 * @license ICLASSIC
 */
    $folder=str_replace("\\",'/',dirname(dirname(__FILE__)));
    
    require_once $folder.'/config_app.php';
    require_once $folder.'/plugin/class.jdate.php';
    require_once $folder.'/plugin/class.thumbnail.php';
    require_once $folder.'/plugin/class.sms.php';
    require_once $folder.'/plugin/class.mail.php';
    require_once $folder.'/plugin/class.thumbnail.php';
    
    require_once $folder.'/core/class.dbobject.php';
    require_once $folder.'/core/class.mysqlidb.php';
    require_once $folder.'/core/class.confedit.php';
	class icprime{
        function __construct(){
            global $ic_db_base;
            global $ic_db_host;
            global $ic_db_pass;
            global $ic_db_pref;
            global $ic_db_user;
            
            if(!isset($this->db)){
                $this->db=new MysqliDb($ic_db_host,$ic_db_user,$ic_db_pass,$ic_db_base);
                $this->db->setPrefix($ic_db_pref);
            }
        }
        
        //======================== DATA HANDLERS ==========================
        
        /**
         * This will return count of all columns in table.
         * @param table for count
         * @return count of table
         */
		public function checkall($table) {
            $this->db->get($table);
            return $this->db->count;
		}
        
        /**
         * This will check exist data with number of times repeat.
         * @param data , state , table , num default = 1
         * @return false/true
         */
		public function checkexs($state,$data,$table,$num=1) {
            $this->db->where($state,$data);
            $this->db->get($table);
			if($this->db->count >= $num) {
				return true;
			}else{
				return false;
			}
		}
        
        /**
         * This will get number of rows a state.
         * @param state,data,table 
         * @return count
         */
		public function getnrow($state,$data,$table,$op1='=') {
            $this->db->where($state,$data,$op1);
            $this->db->get($table);
            return $this->db->count;
		}
        /**
         * This will get number of rows 2 states.
         * @param state,data,state2,data2,table
         * @return count
         */
        public function getnrow2($state,$data,$state2,$data2,$table,$op1='=',$op2='=') {
			$this->db->where($state,$data,$op1);
            $this->db->where($state2,$data2,$op2);
            $this->db->get($table);
            return $this->db->count;
		}
        /**
         * This will get number of rows 3 states.
         * @param state,data,state2,data2,...,table
         * @return count
         */
        public function getnrow3($state,$data,$state2,$data2,$state3,$data3,$table,$op1='=',$op2='=',$op3='=') {
			$this->db->where($state,$data,$op1);
            $this->db->where($state2,$data2,$op2);
            $this->db->where($state3,$data3,$op3);
            $this->db->get($table);
            return $this->db->count;
		}
        /**
         * This will get number of rows 4 states.
         * @param state,data,state2,data2,...,table
         * @return count
         */
        public function getnrow4($state,$data,$state2,$data2,$state3,$data3,$state4,$data4,$table,$op1='=',$op2='=',$op3='=',$op4='=') {
			$this->db->where($state,$data,$op1);
            $this->db->where($state2,$data2,$op2);
            $this->db->where($state3,$data3,$op3);
            $this->db->where($state4,$data4,$op4);
            $this->db->get($table);
            return $this->db->count;
		}
        /**
         * This will get number of Like rows a state.
         * @param state,data,table 
         * @return count
         */
		public function getLnrow($state,$data,$table,$op='LIKE') {
            if($op=='LIKE'){$this->db->where($state,"%$data%",'LIKE');}else{$this->db->where($state,"$data",$op);}
            
            $this->db->get($table);
            return $this->db->count;
		}
        /**
         * This will get number of LIKE rows 2 states.
         * @param state,data,state2,data2,table
         * @return count
         */
        public function getLnrow2($state,$data,$state2,$data2,$table,$op='LIKE',$op2='LIKE') {
			if($op=='LIKE'){$this->db->where($state,"%$data%",'LIKE');}else{$this->db->where($state,"$data",$op);}
            if($op2=='LIKE'){$this->db->where($state2,"%$data2%",'LIKE');}else{$this->db->where($state2,"$data2",$op2);}
            $this->db->get($table);
            return $this->db->count;
		}
        
        /**
         * Run a SQL with this func.
         * @param SQL,Params
         * @return Table
         */
        public function getSql($sql,$params) {
            return $this->db->rawQuery($sql,$params);
		}
        
        /**
         * This will get A row column.
         * @param state,data,row,table
         * @return row column data
         */
		public function getArow($state,$data,$row,$table,$op1='=',$order=null,$otype='DESC') {
            $this->db->where($state,$data,$op1);
            if($order!=null){$this->db->orderBy($order,$otype);}
            $query=$this->db->getOne($table,$row);
            return $query[$row];		      
		}
        
        /**
         * This will get A row column.
         * @param state,data,row,table
         * @return row column data
         */
		public function getArow2($state,$data,$state2,$data2,$row,$table,$op1='=',$op2='=',$order=null,$otype='DESC') {
            $this->db->where($state,$data,$op1);
            $this->db->where($state2,$data2,$op2);
            if($order!=null){$this->db->orderBy($order,$otype);}
            $query=$this->db->getOne($table,$row);
            return $query[$row];
		}
        /**
         * This will get Like row completely with ONE params.
         * @param state,data,table
         * @return row
         */
		public function getLrow($state,$data,$table,$all=false,$order=null,$otype='DESC',$limit=null,$op='LIKE') {
			if($op=='LIKE'){$this->db->where($state,"%$data%",'LIKE');}else{$this->db->where($state,"$data",$op);}
            if($order!=null){$this->db->orderBy($order,$otype);}
            if($all){
                if($limit!=null){$query=$this->db->get($table,$limit);}else{$query=$this->db->get($table);}
                if(!empty($query)){
                    return $query;
                }else{
                    return false;
                }
            }else{
                $query=$this->db->get($table,1);
                if(!empty($query)){
                    return $query[0];
                }else{
                    return false;
                }                
            }
		}
        /**
         * This will get Like row completely with two params.
         * @param state,data,table
         * @return row
         */
		public function getLrow2($state,$data,$state2,$data2,$table,$all=false,$order=null,$otype='DESC',$limit=null,$op='LIKE',$op2='LIKE') {
			if($op=='LIKE'){$this->db->where($state,"%$data%",'LIKE');}else{$this->db->where($state,"$data",$op);}
            if($op2=='LIKE'){$this->db->where($state2,"%$data2%",'LIKE');}else{$this->db->where($state2,"$data2",$op2);}
            if($order!=null){$this->db->orderBy($order,$otype);}
            if($all){
                if($limit!=null){$query=$this->db->get($table,$limit);}else{$query=$this->db->get($table);}
                if(!empty($query)){
                    return $query;
                }else{
                    return false;
                }
            }else{
                $query=$this->db->get($table,1);
                if(!empty($query)){
                    return $query[0];
                }else{
                    return false;
                }                
            }
		}
        /**
         * This will get A row completely.
         * @param state,data,table
         * @return row
         */
		public function getrow($state,$data,$table,$all=false,$order=null,$otype='DESC',$limit=null,$op1='=') {
			$this->db->where($state,$data,$op1);
            if($order!=null){$this->db->orderBy($order,$otype);}
            if($all){
                if($limit!=null){$query=$this->db->get($table,$limit);}else{$query=$this->db->get($table);}
                if(!empty($query)){
                    return $query;
                }else{
                    return false;
                }
            }else{
                $query=$this->db->get($table,1);
                if(!empty($query)){
                    return $query[0];
                }else{
                    return false;
                }                
            }

		}
        /**
         * This will get A row completely with two params.
         * @param state,data,table
         * @return row
         */
		public function getrow2($state,$data,$state2,$data2,$table,$all=false,$order=null,$otype='DESC',$limit=null,$op1='=',$op2='=') {
			$this->db->where($state,$data,$op1);
            $this->db->where($state2,$data2,$op2);
            if($order!=null){$this->db->orderBy($order,$otype);}
            if($all){
                if($limit!=null){$query=$this->db->get($table,$limit);}else{$query=$this->db->get($table);}
                if(!empty($query)){
                    return $query;
                }else{
                    return false;
                }
            }else{
                $query=$this->db->get($table,1);
                if(!empty($query)){
                    return $query[0];
                }else{
                    return false;
                }                
            }
		}
        /**
         * This will get A row completely with three params.
         * @param state,data,table
         * @return row
         */
        public function getrow3($state,$data,$state2,$data2,$state3,$data3,$table,$all=false,$order=null,$otype='DESC',$limit=null,$op1='=',$op2='=',$op3='=') {
			$this->db->where($state,$data,$op1);
            $this->db->where($state2,$data2,$op2);
            $this->db->where($state3,$data3,$op3);
            if($order!=null){$this->db->orderBy($order,$otype);}
            if($all){
                if($limit!=null){$query=$this->db->get($table,$limit);}else{$query=$this->db->get($table);}
                if(!empty($query)){
                    return $query;
                }else{
                    return false;
                }
            }else{
                $query=$this->db->get($table,1);
                if(!empty($query)){
                    return $query[0];
                }else{
                    return false;
                }                
            }
		}
        /**
         * This will get A row completely with --four-- params.
         * @param state,data,table
         * @return row
         */
        public function getrow4($state,$data,$state2,$data2,$state3,$data3,$state4,$data4,$table,$all=false,$order=null,$otype='DESC',$limit=null,$op1='=',$op2='=',$op3='=',$op4='=') {
			$this->db->where($state,$data,$op1);
            $this->db->where($state2,$data2,$op2);
            $this->db->where($state3,$data3,$op3);
            $this->db->where($state4,$data4,$op4);
            if($order!=null){$this->db->orderBy($order,$otype);}
            if($all){
                if($limit!=null){$query=$this->db->get($table,$limit);}else{$query=$this->db->get($table);}
                if(!empty($query)){
                    return $query;
                }else{
                    return false;
                }
            }else{
                $query=$this->db->get($table,1);
                if(!empty($query)){
                    return $query[0];
                }else{
                    return false;
                }                
            }
		}
        
        /**
         * This Update table one row's data.
         * @param table,state,value,target,newval
         * @return true/false
         */
		public function updater1($table,$state,$value,$target,$newval,$op1='=') {
			$this->db->where($state,$value,$op1);
            return $this->db->update($table,array($target=>$newval));
		}
        
        /**
         * This update table's two rows data.
         * @param table,state,value,target1,newval1,target2,newval2
         * @return true/false
         */
		public function updater2($table,$state,$value,$target1,$newval1,$target2,$newval2,$op1='=') {
			$this->db->where($state,$value,$op1);
            return $this->db->update($table,array($target1=>$newval1,$target2=>$newval2));
		}
        /**
         * This update table's ALL rows send data.
         * @param table,state,value,targetarray[]
         * @return true/false
         */
        public function update_all($table,$state,$value,$targetarray,$op1='=') {
			$this->db->where($state,$value,$op1);
            return $this->db->update($table,$targetarray);
		}
        /**
         * This update two params table's ALL rows send data.
         * @param table,statearray[],targetarray[]
         * @return true/false
         */
        public function update_2p_all($table,$state,$data,$state2,$data2,$targetarray,$op1='=',$op2='=') {
		    $this->db->where($state,$data,$op1);
            $this->db->where($state2,$data2,$op2);
            return $this->db->update($table,$targetarray);
		}
        /**
         * This Insert Data to table
         * @param table,targetarray[]
         * @return true/false
         */
        public function insert_all($table,$targetarray) {
            return $this->db->insert($table,$targetarray);
		}
        
        /**
         * This Update table one row's data.
         * @param table,state,value
         * @return true/false
         */
		public function delts($table,$state,$value) {
			$this->db->where($state,$value);
            return  $this->db->delete($table);
		}  
        /**
         * Catch all rows
         */
        public function getrow_all($table,$order=null,$limit=null){
            if($order!=null){$this->db->orderBy($order,'DESC');}
            if($limit!=null){$query=$this->db->get($table,$limit);}else{$query=$this->db->get($table);}
            return $query;
		}
        /**
         * Catch rows with paginate
         */
        function getrow_paginate($page=1,$limit=20,$table,$order='id',$porder='desc'){
            $this->db->orderBy($order,$porder);
            $this->db->pageLimit = $limit;
            $query['result'] = $this->db->arraybuilder()->paginate($table, $page);
            $query['total']=$this->db->totalPages;
            if($query['total']>1){
                $query['paged']=true;
            }else{
                $query['paged']=false;
            }
            $query['page']=$page;
            if($this->db->count > 0){
                return $query;
            }else{
                return false;
            }
        }
        /**
         * Catch all rows with paginate flags
         */
        function getrow_paginate1($state,$data,$table,$page=1,$limit=20,$order='id',$porder='desc',$op1='='){
            $this->db->orderBy($order,$porder);
            $this->db->where($state,$data,$op1);
            $this->db->pageLimit = $limit;
            $query['result'] = $this->db->arraybuilder()->paginate($table,$page);
            $query['total']=$this->db->totalPages;
            if($query['total']>1){
                $query['paged']=true;
            }else{
                $query['paged']=false;
            }
            $query['page']=$page;
            if($this->db->count > 0){
                return $query;
            }else{
                return false;
            }
        }
        /**
         * Catch all rows with paginate flags
         */
        function getrow_paginate2($state,$data,$state2,$data2,$table,$page=1,$limit=20,$order='id',$porder='desc',$op1='=',$op2='='){
            $this->db->orderBy($order,$porder);
            $this->db->where($state,$data,$op1);
            $this->db->where($state2,$data2,$op2);
            $this->db->pageLimit = $limit;
            $query['result'] = $this->db->arraybuilder()->paginate($table,$page);
            $query['total']=$this->db->totalPages;
            if($query['total']>1){
                $query['paged']=true;
            }else{
                $query['paged']=false;
            }
            $query['page']=$page;
            if($this->db->count > 0){
                return $query;
            }else{
                return false;
            }
        }
        /**
         * Catch all rows with paginate flags
         */
        function getrow_paginate3($state,$data,$state2,$data2,$state3,$data3,$table,$page=1,$limit=20,$order='id',$porder='desc',$op1='=',$op2='=',$op3='='){
            $this->db->orderBy($order,$porder);
            $this->db->where($state,$data,$op1);
            $this->db->where($state2,$data2,$op2);
            $this->db->where($state3,$data3,$op3);
            $this->db->pageLimit = $limit;
            $query['result'] = $this->db->arraybuilder()->paginate($table,$page);
            $query['total']=$this->db->totalPages;
            if($query['total']>1){
                $query['paged']=true;
            }else{
                $query['paged']=false;
            }
            $query['page']=$page;
            if($this->db->count > 0){
                return $query;
            }else{
                return false;
            }
        }
        //======================== CASH ========================
        /**
         * CASH
         * This func. return CASH Log
         * @param uid , page(1) , limit(20)
         * @return True/False
         */
        function cash_log_get($uid=null,$flag=null,$status=null,$page=1,$limit=25,$date=null,$op='='){
            
            
            if($date!=null){
                $this->db->where('date',$date,$op);
            }
            
            if($status!=null){
                $this->db->where('status',$status);
            }
            
            if($flag!=null){
                $this->db->where('flag',$flag);
                $this->db->where('status','1');
            }
            if($uid!=null){
                $this->db->where('uid',$uid);
                $this->db->where('uid','0','=','OR');
                //$date=$this->getArow('id',$uid,'date','users');
                //$this->db->where('date',$date,'>=');
            }
            if($date!=null){
                $this->db->where('date',$date,$op);
            }
            
            if($status!=null){
                $this->db->where('status',$status);
            }
            
            if($flag!=null){
                $this->db->where('flag',$flag);
                $this->db->where('status','1');
            }
            $this->db->orderBy('id','desc');

            $this->db->pageLimit = $limit;
            $query['result'] = $this->db->arraybuilder()->paginate("cash", $page);
            $query['total']=$this->db->totalPages;
            $query['pagecount']=$page;
            $query['ss']=$date;
            
            if($this->db->count > 0){
                return $query;
            }else{
                return false;
            }
        }
        /**
         * CASH
         * This func. Get CASH 
         * @param uid
         * @return True/False
         */
        function cash_get($uid){
            $date=$this->getArow('id',$uid,'date','users');
            $this->db->where('uid',$uid);
            $this->db->where('status','1');
            $this->db->where('uid','0','=','OR');
            $this->db->where('date',$date,'>=');
            $query=$this->db->get('cash');
            $cash=0;
            if($this->db->count > 0){ 
                foreach($query as $data){ 
                    if($data['flag']=='pos'){
                        $cash=($data['mount']+$cash); 
                    }elseif($data['flag']=='neg'){
                        $cash=($cash-$data['mount']); 
                    }
                }
            }
            return $cash;
        }
        
        //======================= INEGAR (SUPPORT) ====================
        
        //======================== INEGAR ========================
        /**
         * INEGAR
         * This func. return INEGAR new pm
         * @param `pmto`,`title`,`content`,`date`,`part`,`uid`
         * @return TRUE/FALSE
         */
        function inegar_new($data){
            $data['date']=jdate('Y/m/d H:i:s');
            return $this->db->insert('inegar',$data);
        }
        
        /**
         * INEGAR
         * This func. return INEGAR new reply
         * @param `pmto`,`repmid`,`title`,`content`,`uid`,`date`
         * @return TRUE/FALSE
         */
        function inegar_reply($data=''){
            $data['date']=jdate('Y/m/d H:i:s');
            return $this->db->insert('inegar',$data);
        }
        
        /**
         * INEGAR
         * This func. return INEGAR new notification
         * @param $uid , $flag
         * @return TRUE/FALSE
         */
        function inegar_get_new($uid,$flag){
            $query=$this->getnrow3('uid',$uid,'repmid','0','flaguid',$flag,'inegar');
            return $query;
        }
        
        /**
         * INEGAR
         * This func. return INEGAR new notification
         * @param $uid
         * @return TRUE/FALSE
         */
        function inegar_get_pms($uid=null,$pmto=null,$part='',$page=1){
            if(isset($uid)){
                if($part!=null && $part!='support'){
                    $this->db->where('repmid',0);
                    $this->db->where('part',$part);
                    $this->db->where('pmto',$uid);
                    $this->db->where('flagpmto','3','!=');
                    $this->db->orWhere('uid',$uid);
                    $this->db->where('part',$part);
                    $this->db->where('flaguid','3','!=');
                    $this->db->where('repmid',0);
                }else{
                    $this->db->where('repmid',0);
                    $this->db->where('flagpmto','3','!=');
                    $this->db->where('pmto',$uid);
                    $this->db->orWhere('uid',$uid);
                    $this->db->where('flaguid','3','!=');
                    $this->db->where('repmid',0);
                }                
            }else{
                $this->db->where('repmid',0);
                $this->db->where('part',$part);
            }
            $this->db->orderBy('pmid','desc');
            $this->db->pageLimit = 30;
            $query['result'] = $this->db->arraybuilder()->paginate("inegar", $page);
            $query['total']=$this->db->totalPages;
            $query['pagecount']=$page;
            if($this->db->count > 0){
                return $query;
            }else{
                return false;
            }
        }
        
        /**
         * INEGAR
         * This func. return INEGAR new notification
         * @param uid , pmid
         * @return query string
         */
        function inegar_get_pmrep($pmid){
            $data['first']=$this->getrow('pmid',$pmid,'inegar');
            $this->db->where('repmid',$pmid);
            $this->db->orderBy('pmid','asc');
            $data['child']=$this->db->get('inegar');
            $data['cchild']=$this->db->count;
            return $data;
        }
        
    }
?>